package org.amse.mm.io;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import javax.xml.parsers.*;

import org.amse.mm.myVirtualBilliards.model.*;


public class XMLReader {
	private InputSource mySource;
	private SAXParser myParser;
	private DefaultHandler myDocumentHandler;
	private ITable myTable;
	private boolean myClearBalls;
	
	public XMLReader(InputStream stream, ITable table, boolean clearBalls){
		try{
			Reader reader = new InputStreamReader(stream);
			mySource = new InputSource(reader);
			myClearBalls = clearBalls;
			myParser = SAXParserFactory.newInstance().newSAXParser();
		}catch(Exception e){
			throw new RuntimeException();
		}
		
		myDocumentHandler = new XMLParser();
		myTable = table;
	}
	
	public void parse() throws Exception{
		if (myClearBalls){
			myTable.clearTable();
		}
		myParser.parse(mySource, myDocumentHandler);
	}
	
	class XMLParser extends DefaultHandler{
		public void startElement(String uri, String localName, String qualifiedName,  
								 Attributes attributes){
			if (qualifiedName.equals("ball")){
				createBall(attributes);
			}
			if (qualifiedName.equals("friction")){
				setFriction(attributes);
			}
		}
		
		public void endElement(String uri, String localName, String qualifiedName){
			
		}
		
		private void createBall(Attributes attr){
			try {
				Double x = Double.parseDouble(attr.getValue("x"));
				Double y = Double.parseDouble(attr.getValue("y"));
				BallColor color  = BallColor.valueOf(attr.getValue("color"));
				myTable.addBall(x, y, color);
			}catch(Exception e){
			}
		}
		
		private void setFriction(Attributes attr){
			try{
				myTable.setFriction(Double.parseDouble(attr.getValue("value")));
			}catch(Exception e){
			}
		}
	}
}
